<?php include 'db.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Assignment Report</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    @media print {
      .no-print { display: none; }
      body { background: white; }
    }
  </style>
</head>
<body class="container py-4">

<?php
if (!isset($_GET['id'])) {
    echo "<div class='alert alert-danger'>No assignment selected!</div>";
    exit;
}

$id = intval($_GET['id']);

// Get assignment info
$query = $conn->query("
    SELECT a.*, p.name AS project_name, p.owner_name
    FROM assignments a
    LEFT JOIN projects p ON p.id = a.project_id
    WHERE a.id = $id
");
if ($query->num_rows == 0) {
    echo "<div class='alert alert-warning'>Assignment not found!</div>";
    exit;
}
$assignment = $query->fetch_assoc();

// Get payments for this assignment
$payments = $conn->query("
    SELECT * FROM assignment_payments
    WHERE assignment_id = $id
    ORDER BY payment_date DESC
");

// Total paid
$totalPaid = 0;
foreach ($payments as $p) {
    $totalPaid += $p['amount'];
}
$balance = $assignment['agreed_amount'] - $totalPaid;
?>

<div class="text-center mb-4">
  <h3 class="text-warning">Assignment Payment Report</h3>
  <h5 class="text-secondary"><?= htmlspecialchars($assignment['project_name']); ?></h5>
</div>

<div class="card mb-4 shadow-sm">
  <div class="card-body">
    <h5 class="card-title text-primary mb-3">Assignment Details</h5>
    <table class="table table-bordered">
      <tr>
        <th width="25%">Fundi Name</th>
        <td><?= htmlspecialchars($assignment['worker_name']); ?></td>
      </tr>
      <tr>
        <th>Task Description</th>
        <td><?= htmlspecialchars($assignment['task']); ?></td>
      </tr>
      <tr>
        <th>Agreed Amount (Tshs.)</th>
        <td><?= number_format($assignment['agreed_amount'], 2); ?></td>
      </tr>
      <tr>
        <th>Total Paid (Tshs.)</th>
        <td><?= number_format($totalPaid, 2); ?></td>
      </tr>
      <tr>
        <th>Remaining Balance (Tshs.)</th>
        <td class="<?= $balance <= 0 ? 'text-success fw-bold' : 'text-danger fw-bold' ?>">
          <?= number_format($balance, 2); ?>
        </td>
      </tr>
    </table>
  </div>
</div>

<h5 class="mb-3 text-primary">Payment History</h5>
<table class="table table-striped table-bordered align-middle">
  <thead class="table-dark">
    <tr>
      <th>#</th>
      <th>Amount (Tshs.)</th>
      <th>Payment Date</th>
      <th>Reference</th>
    </tr>
  </thead>
  <tbody>
    <?php
    if ($payments->num_rows == 0) {
        echo "<tr><td colspan='4' class='text-center text-muted'>No payments recorded yet.</td></tr>";
    } else {
        $i = 1;
        foreach ($payments as $pay) {
            echo "<tr>
                    <td>{$i}</td>
                    <td>" . number_format($pay['amount'], 2) . "</td>
                    <td>{$pay['payment_date']}</td>
                    <td>" . ($pay['reference'] ? htmlspecialchars($pay['reference']) : '-') . "</td>
                  </tr>";
            $i++;
        }
    }
    ?>
  </tbody>
</table>

<div class="no-print mt-4">
  <button onclick="window.print()" class="btn btn-success">🖨️ Print Report</button>
  <a href="assignments.php" class="btn btn-secondary">← Back</a>
</div>

</body>
</html>
