<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Projects</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
<style>
  .btn-assigned:hover { cursor: not-allowed; }
  .table-warning { background-color: #fff3cd !important; } /* Assigned only */
  .table-success { background-color: #d4edda !important; } /* Completed only */
  .table-info { background-color: #cce5ff !important; }    /* Completed & Assigned */
</style>
</head>
<body class="container py-4">

<h2>Projects</h2>

<!-- Legend for Row Colors -->
<div class="mb-3">
  <span class="badge bg-success">Completed</span>
  <span class="badge bg-warning text-dark">Assigned</span>
  <span class="badge bg-info text-dark">Completed & Assigned</span>
</div>

<?php
// ------------------- HANDLE ADD PROJECT -------------------
if (isset($_POST['add'])) {
    $progress = intval($_POST['progress']);
    $progress = max(0, min(100, $progress));
    $stmt = $conn->prepare("INSERT INTO projects (name, owner_name, description, start_date, end_date, progress) VALUES (?,?,?,?,?,?)");
    $stmt->bind_param("sssssi", $_POST['name'], $_POST['owner_name'], $_POST['description'], $_POST['start_date'], $_POST['end_date'], $progress);
    $stmt->execute();
    header("Location: projects.php?success=added");
    exit();
}

// ------------------- HANDLE UPDATE PROJECT -------------------
if (isset($_POST['update'])) {
    $id = intval($_POST['id']);
    $progress = intval($_POST['progress']);
    $progress = max(0, min(100, $progress));
    $stmt = $conn->prepare("UPDATE projects SET name=?, owner_name=?, description=?, start_date=?, end_date=?, progress=? WHERE id=?");
    $stmt->bind_param("ssssssi", $_POST['name'], $_POST['owner_name'], $_POST['description'], $_POST['start_date'], $_POST['end_date'], $progress, $id);
    $stmt->execute();
    header("Location: projects.php?success=updated");
    exit();
}

// ------------------- HANDLE DELETE PROJECT -------------------
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $check = $conn->prepare("SELECT COUNT(*) FROM assignments WHERE project_id = ?");
    $check->bind_param("i", $id);
    $check->execute();
    $check->bind_result($count);
    $check->fetch();
    $check->close();

    if ($count > 0) {
        header("Location: projects.php?error=assigned");
        exit();
    } else {
        $stmt = $conn->prepare("DELETE FROM projects WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        header("Location: projects.php?success=deleted");
        exit();
    }
}

// ------------------- SHOW ALERTS -------------------
if (isset($_GET['success'])) {
    switch ($_GET['success']) {
        case 'added': echo "<div class='alert alert-success'>Project Added!</div>"; break;
        case 'updated': echo "<div class='alert alert-info'>Project Updated!</div>"; break;
        case 'deleted': echo "<div class='alert alert-danger'>Project Deleted!</div>"; break;
    }
}
if (isset($_GET['error']) && $_GET['error'] == 'assigned') {
    echo "<div class='alert alert-warning'>❌ This project cannot be deleted because it has already been assigned to a fundi.</div>";
}

// ------------------- PAGINATION -------------------
$limit = 10;
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$offset = ($page - 1) * $limit;
$result = $conn->query("SELECT * FROM projects ORDER BY id DESC LIMIT $limit OFFSET $offset");

// Collect all rows to generate modals later
$projects = [];
while ($row = $result->fetch_assoc()) {
    $pid = $row['id'];
    $assignStmt = $conn->prepare("SELECT worker_name, task, agreed_amount, amount_paid, progress FROM assignments WHERE project_id = ?");
    $assignStmt->bind_param("i", $pid);
    $assignStmt->execute();
    $assignResult = $assignStmt->get_result();
    $fundis = [];
    while ($f = $assignResult->fetch_assoc()) { $fundis[] = $f; }
    $assignStmt->close();

    $row['fundis'] = $fundis;
    $row['isAssigned'] = count($fundis) > 0;
    $row['rowClass'] = ($row['progress'] == 100 && $row['isAssigned']) ? 'table-info' : (($row['progress']==100)?'table-success':($row['isAssigned']?'table-warning':'')) ;
    $projects[] = $row;
}
?>

<!-- Add Project Form -->
<form method="POST" class="row g-3 mb-2" onsubmit="return confirm('Do you really want to add this project?');">
  <div class="col-md-3"><input type="text" name="name" class="form-control" placeholder="Project Name" required></div>
  <div class="col-md-3"><input type="text" name="owner_name" class="form-control" placeholder="Owner Name" required></div>
  <div class="col-md-2"><input type="text" name="description" class="form-control" placeholder="Description"></div>
  <div class="col-md-2"><input type="date" name="start_date" class="form-control"></div>
  <div class="col-md-2"><input type="date" name="end_date" class="form-control"></div>
  <div class="col-md-1"><input type="number" name="progress" class="form-control" placeholder="%" min="0" max="100"></div>
  <div class="col-md-1"><button type="submit" name="add" class="btn btn-primary w-100">Add</button></div>
</form>

<!-- Search -->
<div class="row mb-3">
  <div class="col-md-4">
    <input type="text" id="searchInput" class="form-control" placeholder="Search projects by name or owner">
  </div>
</div>

<!-- Table -->
<div class="table-responsive">
<table class="table table-bordered table-striped align-middle">
<thead class="table-dark">
<tr>
  <th>ID</th><th>Name</th><th>Owner</th><th>Description</th>
  <th>Start</th><th>End</th><th>Progress</th><th>Actions</th>
</tr>
</thead>
<tbody>
<?php foreach($projects as $row): ?>
<tr class="<?= $row['rowClass']; ?>">
  <td><?= $row['id']; ?></td>
  <td><?= htmlspecialchars($row['name']); ?></td>
  <td><?= htmlspecialchars($row['owner_name']); ?></td>
  <td><?= htmlspecialchars($row['description']); ?></td>
  <td><?= $row['start_date']; ?></td>
  <td><?= $row['end_date']; ?></td>
  <td><?= $row['progress']; ?>%</td>
  <td>
    <!-- Edit Modal Trigger -->
    <button class="btn btn-warning btn-sm mb-1" data-bs-toggle="modal" data-bs-target="#editProjectModal<?= $row['id']; ?>">Edit</button>

    <?php if (!$row['isAssigned']): ?>
      <a href="?delete=<?= $row['id']; ?>" class="btn btn-danger btn-sm mb-1" onclick="return confirm('Do you really want to delete this project?');">Delete</a>
    <?php else: ?>
      <button class="btn btn-secondary btn-sm btn-assigned mb-1" disabled title="Cannot delete — assigned to a fundi.">Assigned</button>
    <?php endif; ?>

    <?php if ($row['isAssigned']): ?>
      <!-- Assigned Fundis Modal Trigger -->
      <button class="btn btn-info btn-sm mb-1" data-bs-toggle="modal" data-bs-target="#assignedModal<?= $row['id']; ?>">👷 View Fundis</button>
    <?php endif; ?>
  </td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
</div>

<!-- Pagination -->
<?php
$countResult = $conn->query("SELECT COUNT(*) as total FROM projects");
$totalRows = $countResult->fetch_assoc()['total'];
$totalPages = ceil($totalRows / $limit);
if ($totalPages > 1):
?>
<nav>
<ul class="pagination">
<?php for ($i=1;$i<=$totalPages;$i++): ?>
  <li class="page-item <?= ($i==$page)?'active':'' ?>"><a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a></li>
<?php endfor; ?>
</ul>
</nav>
<?php endif; ?>

<!-- Buttons -->
<div class="text-center mt-4">
    <a href="index.php" class="btn btn-primary">Home</a>
    <a href="budgets.php" class="btn btn-secondary me-2">Budgets</a>
    <a href="assignments.php" class="btn btn-success">Assignments</a>
    <a href="#" class="btn btn-success">Logout</a>
</div>

<!-- Scroll Buttons -->
<button onclick="scrollToTop()" class="btn btn-primary btn-sm rounded-circle" 
        style="position:fixed;bottom:70px;right:20px; width:40px; height:40px; display:flex; align-items:center; justify-content:center;">
  <i class="bi bi-arrow-up"></i>
</button>
<button onclick="scrollToBottom()" class="btn btn-primary btn-sm rounded-circle" 
        style="position:fixed;bottom:20px;right:20px; width:40px; height:40px; display:flex; align-items:center; justify-content:center;">
  <i class="bi bi-arrow-down"></i>
</button>

<!-- ===== MODALS (Outside Table) ===== -->
<?php foreach($projects as $row): ?>
<!-- Edit Project Modal -->
<div class="modal fade" id="editProjectModal<?= $row['id']; ?>" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="POST" onsubmit="return confirm('Do you really want to update this project?');">
        <input type="hidden" name="id" value="<?= $row['id']; ?>">
        <div class="modal-header">
          <h5 class="modal-title">Edit Project - <?= htmlspecialchars($row['name']); ?></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <div class="mb-2"><input type="text" name="name" class="form-control" placeholder="Project Name" value="<?= htmlspecialchars($row['name']); ?>" required></div>
          <div class="mb-2"><input type="text" name="owner_name" class="form-control" placeholder="Owner Name" value="<?= htmlspecialchars($row['owner_name']); ?>" required></div>
          <div class="mb-2"><input type="text" name="description" class="form-control" placeholder="Description" value="<?= htmlspecialchars($row['description']); ?>"></div>
          <div class="mb-2"><input type="date" name="start_date" class="form-control" value="<?= $row['start_date']; ?>"></div>
          <div class="mb-2"><input type="date" name="end_date" class="form-control" value="<?= $row['end_date']; ?>"></div>
          <div class="mb-2"><input type="number" name="progress" class="form-control" placeholder="%" value="<?= $row['progress']; ?>" min="0" max="100"></div>
        </div>
        <div class="modal-footer">
          <button type="submit" name="update" class="btn btn-success">Save</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php if($row['isAssigned']): ?>
<!-- Assigned Fundis Modal -->
<div class="modal fade" id="assignedModal<?= $row['id']; ?>" tabindex="-1">
  <div class="modal-dialog modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Assigned Fundis - <?= htmlspecialchars($row['name']); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <table class="table table-sm table-bordered">
          <thead>
            <tr>
              <th>Name</th>
              <th>Task</th>
              <th>Agreed Amount</th>
              <th>Amount Paid</th>
              <th>Progress</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($row['fundis'] as $f): ?>
            <tr>
              <td><?= htmlspecialchars($f['worker_name']); ?></td>
              <td><?= htmlspecialchars($f['task']); ?></td>
              <td><?= $f['agreed_amount']; ?></td>
              <td><?= $f['amount_paid']; ?></td>
              <td><?= $f['progress']; ?>%</td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>
<?php endforeach; ?>

<script>
function scrollToTop(){window.scrollTo({top:0,behavior:'smooth'});}
function scrollToBottom(){window.scrollTo({top:document.body.scrollHeight,behavior:'smooth'});}

// Auto-hide alerts
setTimeout(()=>{const a=document.querySelector('.alert');if(a){a.style.transition='opacity 0.5s ease';a.style.opacity='0';setTimeout(()=>a.remove(),500);}},5000);

// Automatic search
document.getElementById('searchInput').addEventListener('input', function(){
    let filter=this.value.toLowerCase();
    document.querySelectorAll('table tbody tr').forEach(row=>{
        let name=row.cells[1].textContent.toLowerCase();
        let owner=row.cells[2].textContent.toLowerCase();
        row.style.display=(name.includes(filter)||owner.includes(filter))?'':'none';
    });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
