<?php
require('fpdf/fpdf.php');
include 'db.php'; // Your DB connection

if(!isset($_GET['project_id']) || !isset($_GET['worker_name'])){
    die("Project ID or Worker Name missing");
}

$project_id = intval($_GET['project_id']);
$worker_name = $_GET['worker_name'];

// Fetch project details
$stmt = $conn->prepare("SELECT name FROM projects WHERE id=?");
$stmt->bind_param("i",$project_id);
$stmt->execute();
$res = $stmt->get_result();
$project = $res->fetch_assoc();
$stmt->close();

// Fetch assignment
$stmt = $conn->prepare("SELECT * FROM assignments WHERE project_id=? AND worker_name=?");
$stmt->bind_param("is",$project_id,$worker_name);
$stmt->execute();
$res = $stmt->get_result();
$assignment = $res->fetch_assoc();
$stmt->close();

if(!$assignment){
    die("No assignment found for this fundi in the selected project.");
}

// Fetch all payments
$stmt = $conn->prepare("SELECT * FROM assignment_payments WHERE assignment_id=? ORDER BY payment_date ASC");
$stmt->bind_param("i",$assignment['id']);
$stmt->execute();
$payments = $stmt->get_result();
$stmt->close();

// Create PDF
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',14);
$pdf->Cell(0,10,"Payment Report for {$worker_name}",0,1,'C');
$pdf->SetFont('Arial','',12);
$pdf->Cell(0,8,"Project: {$project['name']} (ID: {$project_id})",0,1);
$pdf->Cell(0,8,"Date: ".date('d-m-Y'),0,1);
$pdf->Ln(5);

// Table Header
$pdf->SetFont('Arial','B',12);
$pdf->Cell(40,10,'Date',1);
$pdf->Cell(40,10,'Amount (Tshs.)',1);
$pdf->Cell(80,10,'Reference',1);
$pdf->Ln();

$pdf->SetFont('Arial','',12);
$total_paid = 0;
while($p = $payments->fetch_assoc()){
    $pdf->Cell(40,10,date('d-m-Y', strtotime($p['payment_date'])),1);
    $pdf->Cell(40,10,number_format($p['amount'],2),1);
    $pdf->Cell(80,10,$p['reference'],1);
    $pdf->Ln();
    $total_paid += $p['amount'];
}

// Summary
$balance = $assignment['agreed_amount'] - $total_paid;
$pdf->Ln(5);
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,10,"Agreed Amount: Tshs. ".number_format($assignment['agreed_amount'],2),0,1);
$pdf->Cell(0,10,"Total Paid: Tshs. ".number_format($total_paid,2),0,1);
$pdf->Cell(0,10,"Remaining Balance: Tshs. ".number_format($balance,2),0,1);

$pdf->Output('I',"Payment_Report_{$worker_name}_Project_{$project_id}.pdf");
?>
