<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Payments</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
<h2>Payments</h2>
<form method="POST" class="row g-3 mb-4">
  <div class="col-md-4"><select name="project_id" class="form-control" required><option value="">Select Project</option>
  <?php $res = $conn->query("SELECT * FROM projects"); while ($p = $res->fetch_assoc()) { echo "<option value='{$p['id']}'>{$p['name']}</option>"; } ?></select></div>
  <div class="col-md-4"><input type="number" step="0.01" name="amount" class="form-control" placeholder="Amount" required></div>
  <div class="col-md-4"><input type="date" name="payment_date" class="form-control" required></div>
  <div class="col-md-2 mt-2"><button type="submit" name="add" class="btn btn-success w-100">Add</button></div>
</form>
<?php
if (isset($_POST['add'])) {
    $stmt = $conn->prepare("INSERT INTO payments (project_id, amount, payment_date) VALUES (?,?,?)");
    $stmt->bind_param("ids", $_POST['project_id'], $_POST['amount'], $_POST['payment_date']);
    $stmt->execute();
    echo "<div class='alert alert-success'>Payment Added!</div>";
}
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM payments WHERE id=$id");
    echo "<div class='alert alert-danger'>Payment Deleted!</div>";
}
?>
<table class="table table-bordered"><tr><th>ID</th><th>Project</th><th>Amount</th><th>Date</th><th>Action</th></tr>
<?php $result = $conn->query("SELECT payments.*, projects.name AS project_name FROM payments JOIN projects ON payments.project_id = projects.id"); while ($row = $result->fetch_assoc()): ?>
<tr>
  <td><?= $row['id']; ?></td><td><?= $row['project_name']; ?></td><td><?= number_format($row['amount'], 2); ?></td><td><?= $row['payment_date']; ?></td>
  <td><a href="?delete=<?= $row['id']; ?>" class="btn btn-danger btn-sm">Delete</a></td>
</tr>
<?php endwhile; ?></table>
<a href="dashboard.php" class="btn btn-secondary">Back to Dashboard</a>
</body></html>