<?php
include 'db.php';

if (!isset($_GET['project_id'])) {
  die("Invalid request.");
}

$project_id = intval($_GET['project_id']);

// Fetch project details
$project_sql = "SELECT * FROM projects WHERE id = $project_id";
$project_result = $conn->query($project_sql);
$project = $project_result->fetch_assoc();

if (!$project) {
  die("Project not found.");
}

// Fetch owner payments
$payments_sql = "SELECT * FROM payments WHERE project_id = $project_id ORDER BY payment_date DESC";
$payments_result = $conn->query($payments_sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Owner Payment Report - <?php echo htmlspecialchars($project['name']); ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #fff;
      color: #000;
      font-family: "Times New Roman", serif;
      margin: 40px;
    }
    .report-container {
      max-width: 800px;
      margin: 0 auto;
    }
    .report-header {
      text-align: center;
      border-bottom: 2px solid #000;
      margin-bottom: 20px;
      padding-bottom: 10px;
    }
    .report-header h2 {
      margin: 0;
      font-weight: bold;
    }
    .table th, .table td {
      border: 1px dashed #000 !important;
    }
    .table thead {
      background: #f2f2f2;
    }
    .summary {
      margin-top: 20px;
      text-align: right;
      font-size: 1.1em;
    }
    .footer {
      margin-top: 40px;
      text-align: center;
      font-size: 0.9em;
      border-top: 1px solid #000;
      padding-top: 10px;
    }
    @media print {
      .no-print {
        display: none;
      }
      body {
        margin: 0;
      }
    }
  </style>
</head>
<body>

<div class="report-container">
  <div class="report-header">
    <h2>PROJECT OWNER PAYMENT REPORT</h2>
    <p><strong>Company:</strong> Main Office</p>
    <p><strong>Location:</strong> Tanzania</p>
  </div>

  <h5>Project Details</h5>
  <table class="table table-sm">
    <tr><th>Project Name</th><td><?php echo htmlspecialchars($project['name']); ?></td></tr>
    <tr><th>Owner Name</th><td><?php echo htmlspecialchars($project['owner_name']); ?></td></tr>
    <tr><th>Start Date</th><td><?php echo htmlspecialchars($project['start_date']); ?></td></tr>
    <tr><th>End Date</th><td><?php echo htmlspecialchars($project['end_date']); ?></td></tr>
  </table>

  <h5 class="mt-4">Payments</h5>
  <table class="table table-bordered table-striped">
    <thead>
      <tr>
        <th>#</th>
        <th>Date</th>
        <th>Amount (TZS)</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $total = 0;
      $count = 1;
      if ($payments_result->num_rows > 0) {
        while ($row = $payments_result->fetch_assoc()) {
          $total += $row['amount'];
          echo "<tr>
            <td>{$count}</td>
            <td>" . htmlspecialchars($row['payment_date']) . "</td>
            <td>" . number_format($row['amount'], 2) . "</td>
          </tr>";
          $count++;
        }
      } else {
        echo "<tr><td colspan='3' class='text-center'>No payments found</td></tr>";
      }
      ?>
    </tbody>
  </table>

  <div class="summary">
    <strong>Total Paid:</strong> TZS <?php echo number_format($total, 2); ?>
  </div>

  <div class="footer">
    <p>Report generated on <?php echo date('d/m/Y H:i:s'); ?></p>
    <p>Thank you for your business!</p>
  </div>

  <div class="no-print text-center mt-4">
    <button class="btn btn-primary" onclick="window.print()">🖨️ Print Report</button>
    <a href="projects.php" class="btn btn-secondary">⬅️ Back to Projects</a>
  </div>
</div>

</body>
</html>
