<?php
include 'db.php';
header('Content-Type: application/json');

$response = ['success' => false];

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);

    // Pata budget_id na amount
    $get = $conn->prepare("SELECT budget_id, amount FROM owner_payments WHERE id = ?");
    $get->bind_param("i", $id);
    $get->execute();
    $result = $get->get_result()->fetch_assoc();
    $get->close();

    if ($result) {
        $budget_id = $result['budget_id'];
        $amount = $result['amount'];

        // Angalia kama amount hiyo imetumika
        $used_query = $conn->prepare("SELECT used FROM budgets WHERE id = ?");
        $used_query->bind_param("i", $budget_id);
        $used_query->execute();
        $used_result = $used_query->get_result()->fetch_assoc();
        $used_query->close();

        if ($used_result && $used_result['used'] > 0 && $used_result['used'] >= $amount) {
            $response['message'] = "This owner payment cannot be deleted because funds have already been used.";
        } else {
            // Futa rekodi
            $delete = $conn->prepare("DELETE FROM owner_payments WHERE id = ?");
            $delete->bind_param("i", $id);
            if ($delete->execute()) {
                $response['success'] = true;
            } else {
                $response['message'] = "Failed to delete owner payment.";
            }
            $delete->close();
        }
    } else {
        $response['message'] = "Owner payment not found.";
    }
}

echo json_encode($response);
?>
