<?php
include 'db.php';
header('Content-Type: application/json');

$response = ['success' => false];

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);

    // Angalia kama assignment ina malipo yoyote
    $check = $conn->prepare("SELECT COUNT(*) AS count FROM assignment_payments WHERE assignment_id = ?");
    $check->bind_param("i", $id);
    $check->execute();
    $res = $check->get_result()->fetch_assoc();
    $check->close();

    if ($res['count'] > 0) {
        $response['message'] = "This assignment cannot be deleted because payments have already been made.";
    } else {
        $delete = $conn->prepare("DELETE FROM assignments WHERE id = ?");
        $delete->bind_param("i", $id);
        if ($delete->execute()) {
            $response['success'] = true;
        } else {
            $response['message'] = "Failed to delete assignment.";
        }
        $delete->close();
    }
}

echo json_encode($response);
?>
