<?php
include 'db.php';

// ===== Handle Add Budget =====
if (isset($_POST['add_budget'])) {
    $project_id = (int)$_POST['project_id'];
    $allocated = floatval($_POST['allocated']);
    $stmt = $conn->prepare("INSERT INTO budgets (project_id, allocated) VALUES (?, ?)");
    $stmt->bind_param("id", $project_id, $allocated);
    $stmt->execute();
    $stmt->close();
    echo "<script>alert('Budget added successfully!');window.location='budgets.php';</script>";
}

// ===== Handle Edit Allocated =====
if (isset($_POST['edit_budget'])) {
    $budget_id = (int)$_POST['budget_id'];
    $new_allocated = floatval($_POST['allocated']);

    $res = $conn->query("SELECT IFNULL((SELECT SUM(amount) FROM payments WHERE project_id=(SELECT project_id FROM budgets WHERE id=$budget_id)),0) AS owner_paid FROM budgets WHERE id=$budget_id");
    $row = $res->fetch_assoc();
    $owner_paid = floatval($row['owner_paid']);

    if ($new_allocated < $owner_paid) {
        echo "<script>alert('Cannot set allocated amount below already paid!');window.location='budgets.php';</script>";
    } else {
        $stmt = $conn->prepare("UPDATE budgets SET allocated=? WHERE id=?");
        $stmt->bind_param("di", $new_allocated, $budget_id);
        $stmt->execute();
        $stmt->close();
        echo "<script>alert('Budget updated successfully!');window.location='budgets.php';</script>";
    }
}

// ===== Handle Delete Budget =====
if (isset($_GET['delete'])) {
    $budget_id = (int)$_GET['delete'];
    $res = $conn->query("SELECT COUNT(*) AS count FROM payments WHERE project_id IN (SELECT project_id FROM budgets WHERE id=$budget_id)");
    $row = $res->fetch_assoc();
    if ($row['count'] > 0) {
        echo "<script>alert('Cannot delete: Payments exist for this project!');window.location='budgets.php';</script>";
    } else {
        $conn->query("DELETE FROM budgets WHERE id=$budget_id");
        echo "<script>alert('Budget deleted successfully!');window.location='budgets.php';</script>";
    }
}

// ===== Handle Add Owner Payment =====
if (isset($_POST['add_owner_payment'])) {
    $budget_id = (int)$_POST['budget_id'];
    $project_id = (int)$_POST['project_id'];
    $amount = floatval($_POST['amount']);

    // Get allocated and total paid
    $res = $conn->query("SELECT allocated, IFNULL((SELECT SUM(amount) FROM payments WHERE project_id=$project_id),0) AS total_paid FROM budgets WHERE project_id=$project_id");
    $row = $res->fetch_assoc();
    $allocated = floatval($row['allocated']);
    $total_paid = floatval($row['total_paid']);

    if ($total_paid + $amount > $allocated) {
        echo "<script>alert('Cannot pay more than allocated amount!');window.location='budgets.php';</script>";
        exit;
    }

    $payment_date = $_POST['payment_date'] ?: date('Y-m-d H:i:s');
    $stmt = $conn->prepare("INSERT INTO payments (project_id, amount, payment_date) VALUES (?, ?, ?)");
    $stmt->bind_param("ids", $project_id, $amount, $payment_date);
    $stmt->execute();
    $stmt->close();
    echo "<script>alert('Owner payment added successfully!');window.location='budgets.php';</script>";
}

// ===== Fetch Budgets =====
$sql = "SELECT b.id, b.project_id, p.name AS project_name, b.allocated,
            IFNULL((SELECT SUM(amount) FROM payments WHERE project_id = b.project_id), 0) AS owner_paid,
            IFNULL((SELECT SUM(ap.amount) FROM assignment_payments ap JOIN assignments a2 ON a2.id=ap.assignment_id WHERE a2.project_id = b.project_id), 0) AS used
        FROM budgets b
        LEFT JOIN projects p ON p.id = b.project_id
        ORDER BY b.id DESC";
$budgets = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Budgets Management</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">

<div class="d-flex justify-content-between align-items-center mb-3">
    <h4>Project Budgets</h4>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addBudgetModal">+ Add Budget</button>
</div>

<div class="card">
    <div class="card-body table-responsive">
        <table id="budgetsTable" class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Project</th>
                    <th>Allocated (Tshs.)</th>
                    <th>Owner Paid (Tshs.)</th>
                    <th>Used (Tshs.)</th>
                    <th>Remaining Owner Paid (Tshs.)</th>
                    <th>Remaining Budget (Tshs.)</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php $sn=1; while($b = $budgets->fetch_assoc()):
                $allocated = floatval($b['allocated']);
                $owner_paid = floatval($b['owner_paid']);
                $used = floatval($b['used']);
                $remaining_owner = max(0, $owner_paid - $used);
                $remaining_budget = $allocated - $used;
            ?>
                <tr>
                    <td><?= $sn++ ?></td>
                    <td><?= htmlspecialchars($b['project_name']) ?> <small class="text-muted">(#<?= (int)$b['project_id'] ?>)</small></td>
                    <td class="text-end"><?= number_format($allocated,2) ?></td>
                    <td class="text-end"><?= number_format($owner_paid,2) ?></td>
                    <td class="text-end"><?= number_format($used,2) ?></td>
                    <td class="text-end"><?= number_format($remaining_owner,2) ?></td>
                    <td class="text-end"><?= number_format($remaining_budget,2) ?></td>
                    <td class="text-center">
                        <div class="btn-group btn-group-sm" role="group">
                            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#ownerPaymentsModal<?= (int)$b['id'] ?>">Owner Payments</button>
                            <a href="owner_payment_report.php?project_id=<?= (int)$b['project_id'] ?>" target="_blank" class="btn btn-info btn-sm">
                                <i class="bi bi-receipt"></i> Owner Report
                            </a>
                            <button class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#editBudgetModal<?= (int)$b['id'] ?>">Edit</button>
                            <a href="?delete=<?= (int)$b['id'] ?>" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this budget?')">Delete</a>
                        </div>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- ===== Add Budget Modal ===== -->
<div class="modal fade" id="addBudgetModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post">
        <div class="modal-header">
          <h5 class="modal-title">Add Budget</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label>Project</label>
            <select name="project_id" class="form-control" required>
              <option value="">Select Project</option>
              <?php
                $res = $conn->query("SELECT * FROM projects");
                while ($p = $res->fetch_assoc()) {
                    echo "<option value='{$p['id']}'>".htmlspecialchars($p['name'])."</option>";
                }
              ?>
            </select>
          </div>
          <div class="mb-3">
            <label>Allocated Amount</label>
            <input type="number" step="0.01" name="allocated" class="form-control" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" name="add_budget" class="btn btn-primary">Add Budget</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php
mysqli_data_seek($budgets, 0); // Reset pointer for edit & payments modals
while($b = $budgets->fetch_assoc()):
?>

<!-- ===== Owner Payments Modal ===== -->
<div class="modal fade" id="ownerPaymentsModal<?= (int)$b['id'] ?>" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form method="post">
        <input type="hidden" name="budget_id" value="<?= (int)$b['id'] ?>">
        <input type="hidden" name="project_id" value="<?= (int)$b['project_id'] ?>">
        <div class="modal-header">
          <h5 class="modal-title">Owner Payments - <?= htmlspecialchars($b['project_name']) ?></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <?php
          $stmt = $conn->prepare("SELECT allocated, IFNULL((SELECT SUM(amount) FROM payments WHERE project_id=?),0) AS total_paid FROM budgets WHERE project_id=?");
          $stmt->bind_param("ii",$b['project_id'],$b['project_id']);
          $stmt->execute();
          $res_budget = $stmt->get_result()->fetch_assoc();
          $allocated = floatval($res_budget['allocated']);
          $total_paid = floatval($res_budget['total_paid']);
          $balance = $allocated - $total_paid;
          ?>
          <div class="row g-2 mb-3">
            <div class="col-md-4">
              <input type="number" step="0.01" max="<?= $balance ?>" name="amount" class="form-control" placeholder="Amount (Max <?= number_format($balance,2) ?>)" required>
            </div>
            <div class="col-md-4">
              <input type="datetime-local" name="payment_date" class="form-control">
            </div>
            <div class="col-md-4">
              <button type="submit" name="add_owner_payment" class="btn btn-primary w-100">Add Payment</button>
            </div>
          </div>
          <p><strong>Total Paid:</strong> <?= number_format($total_paid,2) ?> | <strong>Remaining Allocation:</strong> <?= number_format($balance,2) ?></p>

          <?php
          $stmt2 = $conn->prepare("SELECT id, amount, payment_date FROM payments WHERE project_id=? ORDER BY payment_date DESC");
          $stmt2->bind_param("i", $b['project_id']);
          $stmt2->execute();
          $payments_res = $stmt2->get_result();
          ?>
          <table class="table table-sm table-bordered">
            <thead>
              <tr>
                <th>Date</th>
                <th class="text-end">Amount (Tshs.)</th>
              </tr>
            </thead>
            <tbody>
              <?php if($payments_res->num_rows > 0): while($p = $payments_res->fetch_assoc()): ?>
                <tr>
                  <td><?= htmlspecialchars($p['payment_date']) ?></td>
                  <td class="text-end"><?= number_format(floatval($p['amount']),2) ?></td>
                </tr>
              <?php endwhile; else: ?>
                <tr><td colspan="2" class="text-center"><em>No payments yet.</em></td></tr>
              <?php endif; ?>
            </tbody>
          </table>
          <?php $stmt->close(); $stmt2->close(); ?>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- ===== Edit Budget Modal ===== -->
<div class="modal fade" id="editBudgetModal<?= (int)$b['id'] ?>" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post">
        <input type="hidden" name="budget_id" value="<?= (int)$b['id'] ?>">
        <div class="modal-header">
          <h5 class="modal-title">Edit Budget for <?= htmlspecialchars($b['project_name']) ?></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label>Allocated Amount</label>
            <input type="number" step="0.01" name="allocated" class="form-control" value="<?= floatval($b['allocated']) ?>" min="<?= floatval($b['used']) ?>" required>
            <small class="text-muted">Cannot be less than used amount (<?= floatval($b['used']) ?>)</small>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" name="edit_budget" class="btn btn-warning">Update</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>
<?php endwhile; ?>

<div class="text-center mt-4">
    <a href="index.php" class="btn btn-primary">Home</a>
    <a href="projects.php" class="btn btn-secondary me-2">Projects</a>
    <a href="assignments.php" class="btn btn-success">Assignments</a>
    <a href="#" class="btn btn-success">Logout</a>
</div>

<!-- ===== Scripts ===== -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function(){
    $('#budgetsTable').DataTable({
        pageLength: 5,
        lengthChange: false,
        order: [],
        columnDefs: [{ orderable: false, targets: 7 }]
    });
});
</script>
</body>
</html>
