<?php include 'db.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Assignments</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body class="container py-4">

<h2 class="text-center text-warning mb-4">Project Assignments</h2>

<!-- ===== Add Assignment Form ===== -->
<form method="POST" class="row g-3 mb-4">
  <div class="col-md-3">
    <select name="project_id" class="form-select" required>
      <option value="">Select Project</option>
      <?php
      $res = $conn->query("SELECT * FROM projects ORDER BY name");
      while ($p = $res->fetch_assoc()) {
          echo "<option value='{$p['id']}'>{$p['name']}</option>";
      }
      ?>
    </select>
  </div>
  <div class="col-md-3">
    <input type="text" name="worker_name" class="form-control" placeholder="Fundi Name" required>
  </div>
  <div class="col-md-3">
    <input type="text" name="task" class="form-control" placeholder="Task Description" required>
  </div>
  <div class="col-md-2">
    <input type="number" step="0.01" name="agreed_amount" class="form-control" placeholder="Agreed Amount" required>
  </div>
  <div class="col-md-1">
    <button type="submit" name="add_assignment" class="btn btn-warning w-100">Add</button>
  </div>
</form>

<?php
// ===== Add Assignment =====
if (isset($_POST['add_assignment'])) {
    $project_id = $_POST['project_id'];
    $worker_name = $_POST['worker_name'];
    $task = $_POST['task'];
    $agreed_amount = $_POST['agreed_amount'];

    $stmt = $conn->prepare("INSERT INTO assignments (project_id, worker_name, task, agreed_amount) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("issd", $project_id, $worker_name, $task, $agreed_amount);
    $stmt->execute();

    echo "<div class='alert alert-success'>Assignment added successfully!</div>";
}

// ===== Add Payment =====
if (isset($_POST['add_payment'])) {
    $assignment_id = $_POST['assignment_id'];
    $amount = $_POST['amount'];

    // Get project id
    $getProject = $conn->query("SELECT project_id, agreed_amount FROM assignments WHERE id=$assignment_id");
    $assignment = $getProject->fetch_assoc();
    $project_id = $assignment['project_id'];
    $agreed_amount = $assignment['agreed_amount'];

    // Get remaining owner funds
    $ownerPaidQuery = $conn->query("SELECT IFNULL(SUM(amount),0) AS total_paid FROM payments WHERE project_id = $project_id");
    $ownerPaid = $ownerPaidQuery->fetch_assoc()['total_paid'];

    $usedQuery = $conn->query("
        SELECT IFNULL(SUM(ap.amount),0) AS total_used
        FROM assignment_payments ap
        JOIN assignments a ON a.id = ap.assignment_id
        WHERE a.project_id = $project_id
    ");
    $totalUsed = $usedQuery->fetch_assoc()['total_used'];

    $remainingOwnerPaid = $ownerPaid - $totalUsed;

    // Get total already paid to this fundi
    $paidFundi = $conn->query("SELECT IFNULL(SUM(amount),0) AS total FROM assignment_payments WHERE assignment_id = $assignment_id")->fetch_assoc()['total'];

    // Validation
    if ($amount + $paidFundi > $agreed_amount) {
        echo "<div class='alert alert-danger'>Cannot pay more than agreed amount (Tshs. " . number_format($agreed_amount,2) . ").</div>";
    } elseif ($amount > $remainingOwnerPaid) {
        echo "<div class='alert alert-danger'>Payment exceeds remaining owner funds (Tshs. " . number_format($remainingOwnerPaid,2) . ").</div>";
    } else {
        $stmt = $conn->prepare("INSERT INTO assignment_payments (assignment_id, amount) VALUES (?, ?)");
        $stmt->bind_param("id", $assignment_id, $amount);
        $stmt->execute();

        echo "<div class='alert alert-success'>Payment recorded successfully!</div>";
    }
}
?>

<!-- ===== Assignments Table ===== -->
<table class="table table-bordered table-striped align-middle text-center">
  <thead class="table-dark">
    <tr>
      <th>ID</th>
      <th>Project</th>
      <th>Fundi Name</th>
      <th>Task</th>
      <th>Agreed</th>
      <th>Paid</th>
      <th>Remaining</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
  <?php
  $result = $conn->query("
    SELECT a.*, p.name AS project_name,
    IFNULL((SELECT SUM(amount) FROM assignment_payments WHERE assignment_id=a.id),0) AS paid
    FROM assignments a
    LEFT JOIN projects p ON p.id=a.project_id
    ORDER BY a.id DESC
  ");

  while ($row = $result->fetch_assoc()):
      $remaining = $row['agreed_amount'] - $row['paid'];

      // calculate remaining owner funds for display
      $ownerPaid = $conn->query("SELECT IFNULL(SUM(amount),0) AS total FROM payments WHERE project_id={$row['project_id']}")->fetch_assoc()['total'];
      $used = $conn->query("SELECT IFNULL(SUM(ap.amount),0) AS total FROM assignment_payments ap JOIN assignments a2 ON a2.id=ap.assignment_id WHERE a2.project_id={$row['project_id']}")->fetch_assoc()['total'];
      $remainingOwnerPaid = $ownerPaid - $used;
  ?>
    <tr>
      <td><?= $row['id']; ?></td>
      <td><?= htmlspecialchars($row['project_name']); ?></td>
      <td><?= htmlspecialchars($row['worker_name']); ?></td>
      <td><?= htmlspecialchars($row['task']); ?></td>
      <td><?= number_format($row['agreed_amount'],2); ?></td>
      <td><?= number_format($row['paid'],2); ?></td>
      <td class="<?= $remaining <= 0 ? 'text-success fw-bold' : 'text-danger' ?>"><?= number_format($remaining,2); ?></td>
      <td>
        <div class="btn-group">
          <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#pay<?= $row['id']; ?>">Pay</button>
          <a href="print_receipt.php?id=<?= $row['id']; ?>" class="btn btn-success btn-sm">Print</a>
          <div class="btn-group dropstart">
            <button class="btn btn-secondary btn-sm dropdown-toggle" data-bs-toggle="dropdown">More</button>
            <ul class="dropdown-menu">
              <li><a class="dropdown-item" href="report_assignments.php?id=<?= $row['id']; ?>">Report</a></li>
              <li><a class="dropdown-item text-danger" href="?delete=<?= $row['id']; ?>" onclick="return confirm('Are you sure to delete this assignment?')">Delete</a></li>
            </ul>
          </div>
        </div>
      </td>
    </tr>

    <!-- ===== Payment Modal ===== -->
    <div class="modal fade" id="pay<?= $row['id']; ?>" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header bg-primary text-white">
            <h5 class="modal-title">Pay <?= htmlspecialchars($row['worker_name']); ?></h5>
            <button class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <form method="post">
            <div class="modal-body">
              <input type="hidden" name="assignment_id" value="<?= $row['id']; ?>">
              <p><strong>Project:</strong> <?= htmlspecialchars($row['project_name']); ?></p>
              <p><strong>Agreed:</strong> Tshs. <?= number_format($row['agreed_amount'],2); ?></p>
              <p><strong>Already Paid:</strong> Tshs. <?= number_format($row['paid'],2); ?></p>
              <p><strong>Remaining Owner Paid Amount:</strong> Tshs. <?= number_format($remainingOwnerPaid,2); ?></p>

              <div class="mb-3">
                <label class="form-label">Amount to Pay (Tshs.)</label>
                <input type="number" step="0.01" name="amount" class="form-control" required>
              </div>
            </div>
            <div class="modal-footer">
              <button type="submit" name="add_payment" class="btn btn-success">Submit</button>
              <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  <?php endwhile; ?>
  </tbody>
</table>

<a href="dashboard.php" class="btn btn-secondary">Back to Dashboard</a>

<script>
// Auto-hide alerts
setTimeout(() => {
  document.querySelectorAll('.alert').forEach(el => {
    el.style.transition = 'opacity 0.5s';
    el.style.opacity = '0';
    setTimeout(() => el.remove(), 500);
  });
}, 5000);
</script>

</body>
</html>
