<?php
session_start();
if (!isset($_SESSION['username'])) {
    echo "<script>window.top.location.href='index.php';</script>";
    exit();
}

// Database connection
include 'connect.php';

// Queries
$sql = "SELECT SUM(qty_Onhand * pr_Cost) AS grand_total FROM products_table";
$sql2 = "SELECT SUM(qty_Onhand * pr_Price) AS grand_total2 FROM products_table";
$result = mysqli_query($conn, $sql);
$result2 = mysqli_query($conn, $sql2);

$grand_total = 0;
if ($row = mysqli_fetch_assoc($result)) {
    $grand_total = $row['grand_total'];
}

$grand_total2 = 0;
if ($row = mysqli_fetch_assoc($result2)) {
    $grand_total2 = $row['grand_total2'];
}
$result3 = $grand_total2 - $grand_total;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Grand Total of Products Cost</title>
    <link rel="stylesheet" href="css/bootstrap.min.css">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-6 mb-4">
                <div class="card shadow border-success">
                    <div class="card-header bg-success text-white text-center">
                        <h4>Grand Value of Products on Hand</h4>
                    </div>
                    <div class="card-body text-center">
                        <h1 class="text-success">Tshs. <?php echo number_format($grand_total, 2); ?></h1>
                    </div>
                </div>
            </div>

            <div class="col-md-6 mb-4">
                <div class="card shadow border-primary">
                    <div class="card-header bg-primary text-white text-center">
                        <h4>Estimated Total Sales of Products on Hand</h4>
                    </div>
                    <div class="card-body text-center">
                        <h1 class="text-primary">Tshs. <?php echo number_format($grand_total2, 2); ?></h1>
                    </div>
                </div>
            </div>

            <div class="col-md-6 mb-4">
                <div class="card shadow border-warning">
                    <div class="card-header bg-warning text-dark text-center">
                        <h4>Estimated Total Profit of Products On Hand</h4>
                    </div>
                    <div class="card-body text-center">
                        <h1 class="text-warning">Tshs. <?php echo number_format($result3, 2); ?></h1>
                    </div>
                </div>
            </div>
        </div>
    </div>
   
    <script src="js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
mysqli_close($conn);
?>
