<?php
session_start();
if (!isset($_SESSION['username'])) {
    echo "<script>window.top.location.href='index.php';</script>"; // Redirect parent window to login page
    exit();
}

include_once 'sample.php';


?>


<!DOCTYPE html>
<html>
<head>
    <title>Product Data Histogram</title>
    <script src="js/chart.js"></script>
</head>
<body>
    <h1>Product Data Histogram</h1>
    <canvas id="productHistogram" width="100" height="50"></canvas>
    <script>
        // Get data from PHP
        var productNames = <?php echo $product_names_json; ?>;
        var productQuantities = <?php echo $product_quantities_json; ?>;
        
        var ctx = document.getElementById('productHistogram').getContext('2d');
        var productHistogram = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: productNames,
                datasets: [{
                    label: 'Product Quantities',
                    data: productQuantities,
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
</body>
</html>
