<?php
session_start();
include 'connect.php';

$sql = "SELECT a.*, p.pr_Name
        FROM stock_adjustments a
        JOIN products_table p ON a.product_id = p.product_id
        ORDER BY a.adjust_date DESC";

$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Stock Adjustments List</title>
    <link rel="stylesheet" href="css/bootstrap.min.css">
</head>
<body>
<div class="container mt-4">
    <h3>Stock Adjustment History</h3>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>Product</th>
                <th>Adjusted Qty</th>
                <th>Reason</th>
                <th>Date/Time</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $i = 1;
            while($row = $result->fetch_assoc()):
            ?>
            <tr>
                <td><?= $i++; ?></td>
                <td><?= $row['pr_Name']; ?></td>
                <td><?= $row['adjust_qty']; ?></td>
                <td><?= $row['reason']; ?></td>
                <td><?= $row['adjust_date']; ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
</body>
</html>
