<?php
session_start();
if (!isset($_SESSION['username'])) {
    echo "<script>window.top.location.href='index.php';</script>"; // Redirect parent window to login page
    exit();
}

include 'connect.php';

$message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $product_number = mysqli_real_escape_string($conn, $_POST['product_number']);
    $pr_Name = mysqli_real_escape_string($conn, $_POST['pr_Name']);
    $pr_Cost = floatval(str_replace(',', '', $_POST['pr_Cost'])); // Remove formatting before saving
    $pr_Price = floatval(str_replace(',', '', $_POST['pr_Price']));

    $sql = "INSERT INTO products_table (product_number, pr_Name, pr_Price, pr_Cost) 
            VALUES ('$product_number', '$pr_Name', '$pr_Price', '$pr_Cost')";

    if (mysqli_query($conn, $sql)) {
        $message = '<div class="alert alert-success">Product added successfully!</div>';
        header("refresh:2; url=displayproducts.php"); // Redirect after 2 seconds
    } else {
        $message = '<div class="alert alert-danger">Error: ' . mysqli_error($conn) . '</div>';
    }

    mysqli_close($conn);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Product</title>
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <script>
        // Function to format numbers with thousand separators and two decimal places
        function formatNumber(input) {
            let value = input.value.replace(/,/g, ''); // Remove existing commas
            let floatValue = parseFloat(value);

            if (!isNaN(floatValue)) {
                input.value = floatValue.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
            }
        }
    </script>
</head>
<body>
    <div class="container mt-5">
        <h2 class="mb-4">Add New Product</h2>

        <?php echo $message; ?>

        <form action="" method="POST">
            <div class="mb-3">
                <label for="product_number" class="form-label">Product Code:</label>
                <input type="text" class="form-control" id="product_number" name="product_number" placeholder="Enter Product Code" required autofocus>
            </div>

            <div class="mb-3">
                <label for="pr_Name" class="form-label">Product Name:</label>
                <input type="text" class="form-control" id="pr_Name" name="pr_Name" placeholder="Enter Product Name" required>
            </div>

            <div class="mb-3">
                <label for="pr_Cost" class="form-label">Cost:</label>
                <input type="text" class="form-control" id="pr_Cost" name="pr_Cost" placeholder="Enter Cost" onblur="formatNumber(this)" required>
            </div>

            <div class="mb-3">
                <label for="pr_Price" class="form-label">Price:</label>
                <input type="text" class="form-control" id="pr_Price" name="pr_Price" placeholder="Enter Price" onblur="formatNumber(this)" required>
            </div>

            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
