<?php
session_start();
if (!isset($_SESSION['username'])) {
    echo "<script>window.top.location.href='index.php';</script>"; // Redirect parent window to login page
    exit();
}

include 'connect.php';

// Get the current page number from URL, if not present default to 1
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 10; // Number of records per page
$offset = ($page - 1) * $limit; // Calculate offset

// Count total records
$total_sql = "SELECT COUNT(*) FROM products_table";
$total_result = mysqli_query($conn, $total_sql);
$total_row = mysqli_fetch_array($total_result);
$total_records = $total_row[0];
$total_pages = ceil($total_records / $limit);

// Fetch data with limit and offset
$sql = "SELECT * FROM products_table LIMIT $limit OFFSET $offset";
$result = mysqli_query($conn, $sql);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <title>CRUD OPERATION</title>
</head>
<body>
<div class="container my-5">
    
    <!-- Existing Buttons Above the Table -->
    <table class="table table-hover">
        <thead>
            <tr>
                <th scope="col">
                    <button class="btn btn-primary"><a href="insproducts.php" class="text-light">Add New Product</a></button>
                </th>
                <th scope="col">
                    <form action="upload_products.php" method="post" enctype="multipart/form-data">
                        <input type="file" name="csv_file" required>
                        <button type="submit" name="submit">Upload</button>
                    </form>
                </th>
                <th scope="col">
                    <form method="POST" action="pdf.php" target="_blank">
                        <input type="submit" name="pdf_creator" value="PDF">
                    </form>
                </th>
                <th scope="col">
                    <form method="post" action="exportproducts.php">
                        <button type="submit" name="export">Export to Excel</button>
                    </form>
                </th>
            </tr>
        </thead>
    </table>
    
    <table class="table table-hover">
        <thead>
            <tr>
                <th scope="col">SNo</th>
                <th scope="col">Product Name</th>
                <th scope="col">Product Code</th>
                <th scope="col">Product Price</th>
                <th scope="col">Product Cost</th>
                <th scope="col">Stock</th>
            </tr>
        </thead>
        <tbody>
        <?php
        if ($result) {
            $serialNo = $offset + 1;
            while ($row = mysqli_fetch_assoc($result)) {
                echo '<tr>
                    <th scope="row">' . $serialNo++ . '</th>
                    <td>' . $row['pr_Name'] . '</td>
                    <td>' . $row['product_number'] . '</td>
                    <td>' . number_format($row['pr_Price']) . '</td>
                    <td>' . number_format($row['pr_Cost']) . '</td>
                    <td>' . $row['qty_Onhand'] . '</td>
                </tr>';
            }
        }
        ?>
        </tbody>
    </table>

    <!-- Pagination Links Below the Table -->
    <nav>
        <ul class="pagination">
            <?php if ($page > 1): ?>
                <li class="page-item"><a class="page-link" href="?page=<?= $page - 1 ?>">Previous</a></li>
            <?php endif; ?>
            
            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>
            
            <?php if ($page < $total_pages): ?>
                <li class="page-item"><a class="page-link" href="?page=<?= $page + 1 ?>">Next</a></li>
            <?php endif; ?>
        </ul>
    </nav>
</div>
</body>
</html>
