<?php
// Database connection
$servername = "localhost"; // Your server
$username = "root";        // Your username
$password = "";            // Your password
$dbname = "prodb"; // Your database name

// Create connection
$conn = mysqli_connect($servername, $username, $password, $dbname);

// Check connection
if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get form data
    $service_name = $_POST['service_name'];
    $amount = $_POST['amount'];

    // Insert query
    $sql = "INSERT INTO add_service (service_name, amount) VALUES (?, ?)";

    // Prepare statement
    if ($stmt = mysqli_prepare($conn, $sql)) {
        // Bind parameters
        mysqli_stmt_bind_param($stmt, "sd", $service_name, $amount);

        // Execute the query
        if (mysqli_stmt_execute($stmt)) {
            echo "<div class='alert alert-success'>New service added successfully.</div>";
        } else {
            echo "<div class='alert alert-danger'>Error: " . mysqli_error($conn) . "</div>";
        }

        // Close the statement
        mysqli_stmt_close($stmt);
    } else {
        echo "<div class='alert alert-danger'>Error: Could not prepare the query.</div>";
    }
}

// Close the connection
mysqli_close($conn);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Service</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <h2 class="mb-4">Add New Service</h2>
    <form action="add_service_form.php" method="POST">
        <div class="mb-3">
            <label for="service_name" class="form-label">Service Name:</label>
            <input type="text" class="form-control" id="service_name" name="service_name" required>
        </div>
        
        <div class="mb-3">
            <label for="amount" class="form-label">Amount Charged:</label>
            <input type="number" class="form-control" step="0.01" id="amount" name="amount" required>
        </div>

        <div class="d-flex justify-content-end">
            <button type="submit" class="btn btn-primary">Submit</button>
        </div>
    </form>
</div>

<!-- Bootstrap JS (optional for form handling) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
