<?php
session_start();
if (!isset($_SESSION['username'])) {
    echo "<script>window.top.location.href='index.php';</script>"; // Redirect parent window to login page
    exit();
}

require('fpdf/fpdf.php');

include 'connect.php';

// Fetch sell_id from URL
$sell_id = isset($_GET['sell_id']) ? intval($_GET['sell_id']) : 0;

// Fetch data with a JOIN query based on sell_id
$sql = "
    SELECT 
        customer_table.cust_name, 
        customer_table.cust_company, 
        customer_table.cust_mobile, 
        customer_table.cust_email, 
        sell.pr_Name, 
        sell.quantity_sold, 
        sell.total_amount, 
        sell.payment_method, 
        sell.paid_amount, 
        (sell.total_amount - sell.paid_amount) AS outstanding_balance 
    FROM 
        customer_table 
    INNER JOIN 
        sell 
    ON 
        customer_table.customer_id = sell.customer_id 
    WHERE 
        sell.sell_id = $sell_id";

$result = $conn->query($sql);
$row = $result->fetch_assoc();

if (!$row) {
    die("No record found for sell_id: $sell_id");
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales Record</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
        }
        th {
            background-color: #f2f2f2;
        }
        .btn {
            background-color: #007bff;
            color: white;
            padding: 10px 15px;
            text-decoration: none;
            border: none;
            cursor: pointer;
            margin-top: 20px;
        }
        .btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <h1>Sales Record Details</h1>
    <table>
        <tr>
            <th>Customer Name</th>
            <td><?php echo $row['cust_name']; ?></td>
        </tr>
        <tr>
            <th>Company</th>
            <td><?php echo $row['cust_company']; ?></td>
        </tr>
        <tr>
            <th>Mobile</th>
            <td><?php echo $row['cust_mobile']; ?></td>
        </tr>
        <tr>
            <th>Email</th>
            <td><?php echo $row['cust_email']; ?></td>
        </tr>
        <tr>
            <th>Product Name</th>
            <td><?php echo $row['pr_Name']; ?></td>
        </tr>
        <tr>
            <th>Quantity Sold</th>
            <td><?php echo $row['quantity_sold']; ?></td>
        </tr>
        <tr>
            <th>Total Amount</th>
            <td><?php echo $row['total_amount']; ?></td>
        </tr>
        <tr>
            <th>Payment Method</th>
            <td><?php echo $row['payment_method']; ?></td>
        </tr>
        <tr>
            <th>Paid Amount</th>
            <td><?php echo $row['paid_amount']; ?></td>
        </tr>
        <tr>
            <th>Outstanding Balance</th>
            <td><?php echo $row['outstanding_balance']; ?></td>
        </tr>
        <tr>
            <th>Date & Time</th>
            <td><?php echo date('Y-m-d H:i:s'); ?></td>
        </tr>
    </table>
    <form action="generate_pdf.php" method="post">
        <input type="hidden" name="sell_id" value="<?php echo $sell_id; ?>">
        <button type="submit" class="btn">Print as PDF</button>
    </form>
</body>
</html>
