<?php
session_start();

// Check if user is logged in
if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit();
}

$username = $_SESSION['username'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard</title>
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="style.css">
    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            display: flex;
            flex-direction: column;
            height: 100vh;
            overflow: hidden;
        }
        .sidebar {
            height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            background-color: #343a40;
            padding-top: 20px;
            transition: all 0.3s;
        }
        .sidebar a, .dropdown-btn {
            padding: 10px 15px;
            text-decoration: none;
            font-size: 18px;
            color: white;
            display: block;
            border: none;
            background: none;
            width: 100%;
            text-align: left;
            cursor: pointer;
        }
        .sidebar a:hover, .dropdown-btn:hover {
            background-color: #495057;
        }
        .dropdown-container {
            display: none;
            background-color: #6c757d;
            padding-left: 15px;
        }
        .main-content {
            margin-left: 250px;
            padding: 20px;
            transition: all 0.3s;
        }
        .toggle-btn {
            position: absolute;
            left: 260px;
            top: 10px;
            background-color: #343a40;
            color: white;
            border: none;
            padding: 10px;
            cursor: pointer;
        }
        .collapsed-sidebar {
            width: 80px;
        }
        .collapsed-sidebar a, .collapsed-sidebar .dropdown-btn {
            text-align: center;
            font-size: 16px;
            padding: 15px;
        }
        .collapsed-sidebar .dropdown-container {
            display: none;
        }
        .collapsed-main {
            margin-left: 80px;
        }
    </style>
</head>
<body>
    <div class="sidebar" id="sidebar">
        <button class="toggle-btn" id="toggleSidebar">☰</button>
        <a href="top_products_chart.php" target="iframe_a">Dashboard</a>
        <button class="dropdown-btn">Products</button>
        <div class="dropdown-container">
            <a href="insproducts.php" target="iframe_a">Create Products</a>
            <a href="displayproducts.php" target="iframe_a">Product List</a>
        </div>
        <button class="dropdown-btn">Expenses</button>
        <div class="dropdown-container">
            <a href="insertexpense.php" target="iframe_a">Create Expense</a>
            <a href="displayexpense.php" target="iframe_a">Expenses List</a>
        </div>
        <a href="logout.php">Logout</a>
    </div>

    <div class="main-content" id="mainContent">
        <iframe src="top_products_chart.php" name="iframe_a" height="900px" width="100%" style="border: none;"></iframe>
    </div>

    <script>
        document.getElementById("toggleSidebar").addEventListener("click", function () {
            let sidebar = document.getElementById("sidebar");
            let mainContent = document.getElementById("mainContent");
            sidebar.classList.toggle("collapsed-sidebar");
            mainContent.classList.toggle("collapsed-main");
        });
        
        var dropdowns = document.getElementsByClassName("dropdown-btn");
        for (let i = 0; i < dropdowns.length; i++) {
            dropdowns[i].addEventListener("click", function () {
                let dropdownContent = this.nextElementSibling;
                dropdownContent.style.display = (dropdownContent.style.display === "block") ? "none" : "block";
            });
        }
    </script>
</body>
</html>
