<?php
session_start();
if (!isset($_SESSION['username'])) {
    echo "<script>window.top.location.href='index.php';</script>"; // Redirect parent window to login page
    exit();
}

include 'connect.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <script src="js/jquery-3.6.0.min.js"></script>
    <title>CRUD OPERATION</title>
    <script>
        $(document).ready(function() {
            function loadProducts(search = '', page = 1) {
                $.ajax({
                    url: "fetch_products.php",
                    method: "POST",
                    data: { search: search, page: page },
                    success: function(data) {
                        $("#productTable tbody").html(data);
                        loadPagination(search);
                    }
                });
            }

            function loadPagination(search = '') {
                $.ajax({
                    url: "pagination.php",
                    method: "POST",
                    data: { search: search },
                    success: function(data) {
                        $(".pagination").html(data);
                    }
                });
            }

            $("#searchBox").on("keyup", function() {
                let search = $(this).val();
                loadProducts(search);
            });

            $(document).on("click", ".page-link", function(e) {
                e.preventDefault();
                let page = $(this).attr("data-page");
                let search = $("#searchBox").val();
                loadProducts(search, page);
            });

            loadProducts(); // Load initial products
        });
    </script>
</head>
<body>
<div class="container my-5">
    <div class="mb-3">
        <form action="upload_products.php" method="post" enctype="multipart/form-data" class="d-inline">
            <input type="file" name="csv_file" required>
            <button type="submit" name="submit" class="btn btn-secondary">Upload</button>
        </form>
        <form method="POST" action="pdf.php" target="_blank" class="d-inline">
            <button type="submit" name="pdf_creator" class="btn btn-danger">PDF</button>
        </form>
        <form method="post" action="exportproducts.php" class="d-inline">
            <button type="submit" name="export" class="btn btn-success">Export to Excel</button>
        </form>
    </div>

    <input type="text" id="searchBox" class="form-control mb-3" placeholder="Search Product...">

    <table class="table table-hover" id="productTable">
        <thead>
            <tr>
                <th>SNo</th>
                <th>Product Name</th>
                <th>Product Code</th>
                <th>Product Price</th>
                <th>Product Cost</th>
                <th>Stock</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <!-- Data will be loaded dynamically -->
        </tbody>
    </table>

    <nav>
        <ul class="pagination">
            <!-- Pagination will be loaded dynamically -->
        </ul>
    </nav>
</div>
</body>
</html>
