<?php
session_start();
if (!isset($_SESSION['username'])) {
    echo "<script>window.top.location.href='index.php';</script>";
    exit();
}

// Database connection
include 'connect.php';

$results = [];
$message = '';
$today = date('Y-m-d');
$start_date = isset($_POST['start_date']) ? $_POST['start_date'] : $today;
$end_date = isset($_POST['end_date']) ? $_POST['end_date'] : $today;

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_sale'])) {
    $sell_id = intval($_POST['sell_id']);
    $product_number = $_POST['product_number'];
    $quantity_sold = intval($_POST['quantity_sold']);
    
    // Update product quantity in products_table
    $update_query = "UPDATE products_table SET qty_Onhand = qty_Onhand + $quantity_sold WHERE product_number = '$product_number'";
    mysqli_query($conn, $update_query);
    
    // Delete row from sell table
    $delete_query = "DELETE FROM sell WHERE sell_id = '$sell_id'";
    mysqli_query($conn, $delete_query);
    
    $message = 'Sale deleted and stock updated!';
}

$query = "SELECT * FROM sell WHERE sell_time BETWEEN '$start_date 00:00:00' AND '$end_date 23:59:59'";
$result = mysqli_query($conn, $query);
if ($result) {
    $results = mysqli_fetch_all($result, MYSQLI_ASSOC);
}

mysqli_close($conn);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Sales Overview</title>
    <link rel="stylesheet" href="css/bootstrap.min.css">
</head>
<body class="container py-4">
    <h1 class="text-center">Sales Overview</h1>
    <?php if ($message): ?>
        <div class="alert alert-info"><?php echo $message; ?></div>
    <?php endif; ?>

    <!-- Date range form -->
    <form method="POST" action="" class="bg-light p-4 rounded shadow-sm">
        <div class="row g-3">
            <div class="col-md-5">
                <label for="start_date" class="form-label">Start Date:</label>
                <input type="date" id="start_date" name="start_date" class="form-control" value="<?php echo $start_date; ?>" required>
            </div>
            <div class="col-md-5">
                <label for="end_date" class="form-label">End Date:</label>
                <input type="date" id="end_date" name="end_date" class="form-control" value="<?php echo $end_date; ?>" required>
            </div>
            <div class="col-md-2 align-self-end">
                <button type="submit" class="btn btn-primary w-100">Fetch Data</button>
            </div>
        </div>
    </form>

    <?php if (!empty($results)): ?>
        <div class="table-responsive mt-4">
            <table class="table table-bordered">
                <thead class="table-dark text-center">
                    <tr>
                        <th>DATE</th>
                        <th>SELL ID</th>
                        <th>CUST. NAME</th>
                        <th>CODE</th>
                        <th>PR. NAME</th>
                        <th>QTY</th>
                        <th>TOTAL</th>
                        <th>P. METHOD</th>
                        <th>P. AMOUNT</th>
                        <th>ACTION</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($results as $row): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['sell_time']); ?></td>
                            <td><?php echo htmlspecialchars($row['sell_id']); ?></td>
                            <td><?php echo htmlspecialchars($row['cust_name']); ?></td>
                            <td><?php echo htmlspecialchars($row['product_number']); ?></td>
                            <td><?php echo htmlspecialchars($row['pr_Name']); ?></td>
                            <td><?php echo htmlspecialchars($row['quantity_sold']); ?></td>
                            <td><?php echo number_format($row['total_amount'], 2); ?></td>
                            <td><?php echo htmlspecialchars($row['payment_method']); ?></td>
                            <td><?php echo number_format($row['paid_amount'], 2); ?></td>
                            <td>
                                <form method="POST" action="">
                                    <input type="hidden" name="sell_id" value="<?php echo $row['sell_id']; ?>">
                                    <input type="hidden" name="product_number" value="<?php echo $row['product_number']; ?>">
                                    <input type="hidden" name="quantity_sold" value="<?php echo $row['quantity_sold']; ?>">
                                    <button type="submit" name="delete_sale" class="btn btn-danger btn-sm">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-warning">No sales data found.</div>
    <?php endif; ?>
</body>
</html>
